//
//  MCTaskRunning.h
//  MCClientServer
//
//  Created by Fraser Kuyvenhoven on 11/19/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Security/Authorization.h>


@interface MCTaskRunning : NSObject
{
}

// ioData is a means to provide input and output, written on standard in and read from standard output, respective
// on input, ioData can be a string, NSData, or an arbitary object; NSData will be passed through unchanged;
// strings will be encoded as data using UTF8 encoding; other objects will be archived with a keyed archiver
// make sure to provide the data in the format your tool expects it; for MCDaemon subclasses, see MCDaemon.h
+ (int)runTaskWithLaunchPath:(NSString *)aPath arguments:(NSArray *)args ioData:(id *)ioData error:(NSString **)errorString;

+ (signed long)runPrivilegedTaskWithAuthorization:(AuthorizationRef)authorization launchPath:(NSString *)aPath
										arguments:(NSArray *)args output:(NSString **)outputString;

@end
